#ifndef DPLATAFORMA_H
    #define DPLATAFORMA_H
    
    #if defined WIN32 || WIN64
        #ifdef DWL_CONFIGURACION
            #include DWL_CONFIGURACION
        #else
            #include "../Config/ConfiguracionPorDefecto.h"
        #endif


        #include <windows.h>

        // Capacidad maxima para los strings
        #define DWL_STR_MAX 0xFFFFFFFF

        // Macro que devuelve el nombre de la funcin actual (Esta macro varia segun el compilador, y no devuelve exactamente lo mismo)
        #ifdef _MSC_VER
            #define __PROTOTIPO_FUNCION__   __FUNCSIG__
        #endif
        #ifdef __GNUC__ 
            #define __PROTOTIPO_FUNCION__   __PRETTY_FUNCTION__
        #endif

        #if defined UNICODE || _UNICODE
            #define DString DStringWC
        #else
            #define DString DStringMB
        #endif

        
        #if defined UNICODE
			// Funciones seguras UNICODE para VC9
			#define DWLStrCopy(Destino, Longitud_Destino, Origen)					wcscpy_s(Destino, Longitud_Destino, Origen)
        	#define DWLStrLen(Texto)												wcslen(Texto)
        	#define DWLStrCmpi(Texto1, Texto2)									   _wcsicmp(Texto1, Texto2)
        	#define DWLStrCmp(Texto1, Texto2)										wcscmp(Texto1, Texto2)
        	#define DWLStrToInt(Texto)											   _wtoi(Texto)
        	#define DWLFOpen(FILE, Path, Modo)							           _wfopen_s(FILE, Path, Modo)
        	#define DWLvsPrintf(Buffer, Longitud_Buffer, Formato_Texto, VA_LIST)	vswprintf_s(Buffer, Longitud_Buffer, Formato_Texto, VA_LIST)
            #define DWLIntToText(Numero, Destino, Longitud_Destino, Base)          _itow_s(Numero, Destino, Longitud_Destino, Base);
         	#define DWLLPCSTR														LPCWSTR        
		#else
			// Funciones ANSI para Visual Studio 9 con funciones seguras
        	#define DWLStrCopy(Destino, Longitud_Destino, Origen)					strcpy_s(Destino, Longitud_Destino, Origen)
        	#define DWLStrLen(Texto)												strlen(Texto)
        	#define DWLStrCmpi(Texto1, Texto2)									   _strcmpi(Texto1, Texto2)
        	#define DWLStrCmp(Texto1, Texto2)										strcmp(Texto1, Texto2)
        	#define DWLStrToInt(Texto)											    atoi(Texto)
        	#define DWLFOpen(FILE, Path, Modo)										fopen_s(FILE, Path, Modo)
        	#define DWLvsPrintf(Buffer, Longitud_Buffer, Formato_Texto, VA_LIST)    vsprintf_s(Buffer, Longitud_Buffer, Formato_Texto, VA_LIST)
            #define DWLIntToText(Numero, Destino, Longitud_Destino, Base)          _itoa_s(Numero, Destino, Longitud_Destino, Base);
         	#define DWLLPCSTR														LPCSTR        
		#endif


    #endif

#endif